/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ValidateEmailCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.toUser("AM:This server does not require email validation.", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("AM:Missing validation code, please try again.  /validateemail [validation code]", Username, true);
            return;
        }
        String codeEntered = command.nextToken().trim();
        if (codeEntered.length() < 1) {
            CampaignMain.cm.toUser("AM:Missing validation code, please try again.  /validateemail [validation code]", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        String validationCode = CampaignMain.cm.MySQL.getActivationKey(player.getForumID());
        if (player.isValidated()) {
            CampaignMain.cm.toUser("AM: Your account has already been validated.", Username, true);
            return;
        }
        if (!validationCode.equals(codeEntered)) {
            CampaignMain.cm.toUser("AM: Invalid validation code, unable to validate your account.", Username, true);
            return;
        }
        player.setUserValidated(true);
        CampaignMain.cm.MySQL.validateUser(player.getForumID());
        player.setSave();
        CampaignMain.cm.toUser("Your account has been validated.  Thank you.", Username, true);
    }
}

