/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.votes.Vote;
import server.campaign.votes.VoteManager;

public class VoteCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer castingPlayer = CampaignMain.cm.getPlayer(Username);
        String recipientName = "";
        int type = 0;
        try {
            recipientName = new String(command.nextToken()).toString();
            type = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:Vote command failed. Check your input. It should be something like this: /c vote#Name#2", Username, true);
            return;
        }
        boolean canVote = new Boolean(CampaignMain.cm.getConfig("VotingEnabled"));
        if (!canVote) {
            CampaignMain.cm.toUser("AM:Voting is disabled on this server.", Username, true);
            return;
        }
        if (castingPlayer.getName().equals(recipientName)) {
            CampaignMain.cm.toUser("AM:You may not vote for youself.", Username, true);
            return;
        }
        if (type < 0 || type > 2) {
            CampaignMain.cm.toUser("AM:You tried to use an illegal vote type. Types are:<br> Positive: 1<br> Negative: 2<br> Abstain: 0", Username, true);
            return;
        }
        int votesCast = CampaignMain.cm.getVoteManager().getAllVotesBy(castingPlayer).size();
        if (votesCast > castingPlayer.getNumberOfVotesAllowed()) {
            CampaignMain.cm.toUser("AM:You have no votes left to cast. Retract one of your currentvotes and try again.", Username, true);
            return;
        }
        SPlayer recipientPlayer = CampaignMain.cm.getPlayer(recipientName);
        if (recipientPlayer == null) {
            CampaignMain.cm.toUser("AM:The player you tried to vote for doesn't exist.", Username, true);
            return;
        }
        if (!castingPlayer.getMyHouse().equals(recipientPlayer.getMyHouse())) {
            CampaignMain.cm.toUser("AM:You may only vote for players in your own faction.", Username, true);
            return;
        }
        Vote toCast = new Vote(type, castingPlayer.getName(), recipientName);
        VoteManager voteManager = CampaignMain.cm.getVoteManager();
        if (voteManager.checkForDuplicate(toCast)) {
            CampaignMain.cm.toUser("AM:You have already cast a vote for this player.", Username, true);
            return;
        }
        boolean voteAdded = voteManager.addVote(toCast);
        if (!voteAdded) {
            CampaignMain.cm.toUser("AM:Your vote was not counted. This is a catchall error -- please contact your server admin and ask them to investigate, or file a bug report.", Username, true);
            return;
        }
        CampaignMain.cm.toUser("AM:You have cast a vote for " + recipientName, Username, true);
    }
}

