/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AddSongCommand
implements Command {
    int accessLevel = 200;
    String syntax = "addsong#songname#lyric1#lyric2....";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        File songList = new File("./data/songs.txt");
        if (!songList.exists()) {
            try {
                songList.createNewFile();
            }
            catch (Exception ex) {
                return;
            }
        }
        String songName = command.nextToken();
        StringBuilder lyrics = new StringBuilder();
        while (command.hasMoreTokens()) {
            lyrics.append(command.nextToken());
            lyrics.append("#");
        }
        lyrics.deleteCharAt(lyrics.length() - 1);
        try {
            FileOutputStream fos = new FileOutputStream(songList, true);
            PrintStream ps = new PrintStream(fos);
            ps.println(songName + "|" + lyrics.toString().trim());
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Unable to append to songs.txt", Username, true);
            return;
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has added " + songName + " to the song list!");
    }
}

