/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminAddServerOpFlagsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet#FlagCode#FlagName#...";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("Syntax AdminAddServerOpFlags#FlagCode#FlagName#...<br>NOTE: you can repeat FlagCode and FlagName multiple times.", Username);
            return;
        }
        try {
            while (command.hasMoreTokens()) {
                String key = command.nextToken();
                String value = command.nextToken();
                CampaignMain.cm.getData().getPlanetOpFlags().put(key, value);
                CampaignMain.cm.toUser("Op flag " + key + "/" + value + " added to the server.", Username, true);
                CampaignMain.cm.doSendModMail("NOTE", Username + " added op flag " + key + "/" + value + ".");
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Syntax AdminAddServerOpFlags#Planet#FlagCode#FlagName#...<br>NOTE: you can repeat FlagCode and FlagName multiple times.", Username);
            return;
        }
    }
}

