/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.House;
import common.Planet;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.Statistics;

public class AdminCalculateHouseRankingsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        HashMap<Integer, Integer> original = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> current = new HashMap<Integer, Integer>();
        for (House h : CampaignMain.cm.getData().getAllHouses()) {
            original.put(h.getId(), 0);
            current.put(h.getId(), 0);
        }
        Collection<Planet> planets = CampaignMain.cm.getData().getAllPlanets();
        for (Planet planet : planets) {
            int originalHouseId = CampaignMain.cm.getData().getHouseByName(planet.getOriginalOwner()).getId();
            original.put(originalHouseId, (Integer)original.get(originalHouseId) + 100);
            for (House h : planet.getInfluence().getHouses()) {
                current.put(h.getId(), (Integer)current.get(h.getId()) + planet.getInfluence().getInfluence(h.getId()));
            }
        }
        TreeSet<HouseRankingHelpContainer> s = CampaignMain.cm.getHouseRanking();
        for (HouseRankingHelpContainer h : s) {
            h.getHouse().setInitialHouseRanking((Integer)original.get(h.getHouse().getId()));
            h.setAmount((Integer)current.get(h.getHouse().getId()));
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has recalculated the faction rankings");
        CampaignMain.cm.toUser("You have recalculated the faction rankings", Username, true);
        String result = "SM|" + Statistics.getReadableHouseRanking(true);
        CampaignMain.cm.toUser(result, Username, false);
    }
}

