/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.HashMap;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminChangePlanetOwnerCommand
implements Command {
    int accessLevel = 200;
    String syntax = "planet#newfaction";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = null;
        SHouse h = null;
        try {
            p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            h = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminchangeplanetowner#planet#newfaction", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Could not find a matching planet.", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("Could not find a matching faction.", Username, true);
            return;
        }
        p.setOwner(p.getOwner(), h, true);
        HashMap<Integer, Integer> flu = new HashMap<Integer, Integer>();
        flu.put(h.getId(), p.getConquestPoints());
        p.getInfluence().setInfluence(flu);
        p.updated();
        CampaignMain.cm.toUser("You gave ownership of " + p.getName() + " to " + h.getName() + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " gave ownership of " + p.getName() + " to " + h.getName() + ".");
    }
}

