/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.UnitFactory;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class AdminCreateFactoryCommand
implements Command {
    int accessLevel = 200;
    String syntax = "planet name#factory name#size#faction#type#subfolder#SubfactionAccessLevel";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int fid = 0;
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
        String name = command.nextToken();
        String size = command.nextToken();
        String faction = command.nextToken();
        String buildTableFolder = "0";
        int accessLevel = 0;
        if (CampaignMain.cm.isUsingMySQL()) {
            fid = CampaignMain.cm.MySQL.getFactoryIdByNameAndPlanet(name, planet.getName());
        }
        int type = Integer.parseInt(command.nextToken());
        if (command.hasMoreElements()) {
            buildTableFolder = command.nextToken();
        }
        if (command.hasMoreElements()) {
            accessLevel = Integer.parseInt(command.nextToken());
        }
        SUnitFactory fac = new SUnitFactory(name, planet, size, faction, 0, 100, type, buildTableFolder, accessLevel);
        fac.setID(fid);
        Vector<UnitFactory> uf = planet.getUnitFactories();
        uf.add(fac);
        fac.setPlanet(planet);
        if (planet.getOwner() != null) {
            planet.getOwner().removePlanet(planet);
            planet.getOwner().addPlanet(planet);
        }
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            fac.toDB();
        }
        CampaignMain.cm.toUser("Factory created!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has created factory " + fac.getName() + " on planet " + planet.getName());
    }
}

