/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Influences;
import java.util.HashMap;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminCreatePlanetCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Xcood#YCoord#";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), Username);
        String PlanetName = command.nextToken();
        double xcood = Double.parseDouble(command.nextToken());
        double ycood = Double.parseDouble(command.nextToken());
        if (faction == null || PlanetName == null) {
            return;
        }
        HashMap<Integer, Integer> flu = new HashMap<Integer, Integer>();
        flu.put(faction.getId(), 100);
        SPlanet planet = new SPlanet(CampaignMain.cm.getData().getUnusedPlanetID(), PlanetName, new Influences(flu), 0, 0, xcood, ycood);
        CampaignMain.cm.addPlanet(planet);
        planet.setOwner(null, faction, true);
        planet.setOriginalOwner(faction.getName());
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
        CampaignMain.cm.toUser("Planet created!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has created planet " + PlanetName);
    }
}

