/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.AdvancedTerrain;
import common.CampaignData;
import common.Continent;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminCreateTerrainCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#TerrainType#Chance";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            String terraintype = command.nextToken();
            int chance = Integer.parseInt(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Planet not found:", Username, true);
                return;
            }
            Continent cont = new Continent(chance, CampaignMain.cm.getData().getTerrainByName(terraintype));
            p.getEnvironments().add(cont);
            if (new Boolean(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                AdvancedTerrain aTerrain = new AdvancedTerrain();
                p.getAdvancedTerrain().put(new Integer(cont.getEnvironment().getId()), aTerrain);
            }
            p.updated();
            CampaignMain.cm.toUser("Terrain added to " + p.getName() + "(" + terraintype + ").", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " added terrain to planet " + p.getName() + "(" + terraintype + ").");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

