/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import common.UnitFactory;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminDestroyFactoryCommand
implements Command {
    int accessLevel = 200;
    int factoryID;
    String syntax = "Planet Name#Factory Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            String factoryname = command.nextToken();
            if (p == null) {
                CampaignMain.cm.toUser("Planet not found:", Username, true);
                return;
            }
            if (p.getUnitFactories().size() < 1) {
                CampaignMain.cm.toUser("This planet does not have any factories!", Username, true);
                return;
            }
            UnitFactory foundFactory = null;
            for (UnitFactory UF : p.getUnitFactories()) {
                if (!UF.getName().equalsIgnoreCase(factoryname)) continue;
                foundFactory = UF;
                break;
            }
            if (foundFactory == null) {
                CampaignMain.cm.toUser("Factory " + factoryname + " not found", Username, true);
                return;
            }
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.deleteFactory(foundFactory.getID());
            }
            p.getUnitFactories().removeElement(foundFactory);
            p.getUnitFactories().trimToSize();
            p.updated();
            CampaignMain.cm.toUser(factoryname + " removed from " + p.getName() + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + "  removed " + factoryname + " from " + p.getName() + ".");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

