/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminDestroyPlanetCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
        SHouse h = p.getOwner();
        if (h != null) {
            h.removePlanet(p);
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deletePlanetFactories(p.getName());
            CampaignMain.cm.MySQL.deletePlanet(p.getDBID());
        }
        CampaignMain.cm.getData().removePlanet(p.getId());
        File fp = new File("./campaign/planets/" + p.getName().toLowerCase().trim() + ".dat");
        if (fp.exists()) {
            fp.delete();
        }
        CampaignMain.cm.updateHousePlanetUpdate();
        CampaignMain.cm.doSendModMail("NOTE", Username + " unleashed the Death Star on " + p.getName() + ". Planet destroyed!");
    }
}

