/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.util.UnitUtils;
import java.util.Hashtable;
import java.util.StringTokenizer;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MiscType;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminGetUnitComponentsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "TargetPlayer#Option[BreakDownUnit,DisplayParts,AddParts]#Unit[ID,FileName]";

    @Override
    public int getExecutionLevel() {
        return this.accessLevel;
    }

    @Override
    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            String targetName = command.nextToken();
            String option = command.nextToken();
            StringBuffer result = new StringBuffer();
            SPlayer target = CampaignMain.cm.getPlayer(targetName);
            if (target == null) {
                CampaignMain.cm.toUser("Target player could not be found. Try again.", Username, true);
                return;
            }
            if (option.equalsIgnoreCase("DisplayParts")) {
                result.append("You have the current parts stockpiled<br>");
                result.append(target.getUnitParts().tableizeComponents());
                CampaignMain.cm.toUser(result.toString(), Username);
            } else if (option.equalsIgnoreCase("addParts")) {
                int unitID = Integer.parseInt(command.nextToken());
                SUnit m = target.getUnit(unitID);
                target.getUnitParts().add(this.getUnitComponents(m.getEntity()));
                CampaignMain.cm.toUser("All useable parts from " + m.getModelName() + " where added to " + target.getName() + "'s parts stockpile", Username);
                CampaignMain.cm.toUser("All useable parts from " + m.getModelName() + " where added to your parts stockpile", target.getName());
            } else {
                int unitID = Integer.parseInt(command.nextToken());
                SUnit m = target.getUnit(unitID);
                Hashtable<String, Integer> components = new Hashtable<String, Integer>();
                if (m == null) {
                    CampaignMain.cm.toUser("Target player doesn't have a unit with ID# " + unitID + ".", Username, true);
                    return;
                }
                Entity ent = m.getEntity();
                components.putAll(this.getUnitComponents(ent));
                result.append("Component list for #" + unitID + " " + m.getModelName() + "<br>");
                result.append("<table><tr><th>Component</th><th># of Crits</th></tr>");
                for (String key : components.keySet()) {
                    result.append("<tr><td>");
                    result.append(key);
                    result.append("</td><td>");
                    result.append(components.get(key));
                    result.append("</td></tr>");
                }
                result.append("</table>");
                CampaignMain.cm.toUser(result.toString(), Username);
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid Syntax: /admingetunitcomponents TargetPlayer#Option[BreakDownUnit,DisplayParts,AddParts]#Unit[ID,FileName]", Username);
        }
    }

    public Hashtable<String, Integer> getUnitComponents(Entity ent) {
        Hashtable<String, Integer> components = new Hashtable<String, Integer>();
        int IS = 0;
        int armor = 0;
        int rear = 0;
        String part = "";
        for (int location = 0; location < ent.locations(); ++location) {
            IS += Math.max(0, ent.getInternal(location));
            armor += Math.max(0, ent.getArmor(location));
            rear += Math.max(0, ent.getArmor(location, true));
            for (int slot = 0; slot < ent.getNumberOfCriticals(location); ++slot) {
                CriticalSlot crit = ent.getCritical(location, slot);
                if (crit == null) continue;
                part = UnitUtils.isActuator(crit) ? "Actuator" : (crit.getType() == 0 ? ((Mech)ent).getSystemName(crit.getIndex()) : ent.getEquipment(crit.getIndex()).getType().getInternalName());
                if (components.containsKey(part)) {
                    components.put(part, components.get(part) + 1);
                    continue;
                }
                components.put(part, 1);
            }
        }
        components.put("Armor: " + MiscType.getArmorTypeName(ent.getArmorType()), armor + rear);
        components.put("IS: " + MiscType.getStructureTypeName(ent.getStructureType()), IS);
        return components;
    }
}

