/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Unit;
import java.util.LinkedList;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.PilotQueues;
import server.campaign.SHouse;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class AdminHousePilotsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "faction";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse h = null;
        try {
            h = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminhousepilots#faction", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("Couldn't find a faction with that name.", Username, true);
            return;
        }
        PilotQueues currQ = h.getPilotQueues();
        StringBuilder toReturn = new StringBuilder();
        for (int type = 0; type < 6; ++type) {
            toReturn.append("Faction Base Pilot: " + currQ.getBaseGunnery(type) + "/" + currQ.getBasePiloting(type) + "<br>");
            toReturn.append("Faction Base Pilot Skills: " + currQ.getBasePilotSkill(type) + "<br>");
            toReturn.append("<b>Queue for " + Unit.getTypeClassDesc(type) + ":</b><OL>");
            LinkedList<SPilot> l = currQ.getPilotQueue(type);
            for (SPilot currP : l) {
                toReturn.append("<LI>" + currP.getName() + "(" + currP.getGunnery() + "/" + currP.getPiloting() + ") [" + currP.getSkillString(true) + "]</LI>");
            }
            toReturn.append("</OL>");
        }
        h.updated();
        CampaignMain.cm.toUser(toReturn.toString(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " checked House " + h.getName() + " Pilots");
    }
}

