/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.House;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class AdminListAndRemoveOMGCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        for (House house : CampaignMain.cm.getData().getAllHouses()) {
            SHouse faction = (SHouse)house;
            ConcurrentLinkedQueue units = new ConcurrentLinkedQueue(faction.getHangar(0).elementAt(0));
            for (SUnit currU : units) {
                if (!currU.getModelName().equals("OMG-UR-FD")) continue;
                CampaignMain.cm.doSendModMail("NOTE", Username + " removed an OMG from the " + faction.getName() + " bays. Should have been a " + currU.getUnitFilename() + ".");
                CampaignMain.cm.toUser("Removed an OMG from the " + faction.getName() + " bays. Should have been a " + currU.getUnitFilename() + ".", Username, true);
                faction.getHangar(0).elementAt(0).removeElement(currU);
                CampaignMain.cm.doSendToAllOnlinePlayers(faction, "HS|" + faction.getHSUnitRemovalString(currU), false);
            }
        }
    }
}

