/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.House;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class AdminLockCampaignCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (new Boolean(CampaignMain.cm.getConfig("CampaignLock")).booleanValue()) {
            CampaignMain.cm.toUser("Campaign is already locked.", Username, true);
            return;
        }
        for (House house : CampaignMain.cm.getData().getAllHouses()) {
            SHouse h = (SHouse)house;
            for (SPlayer p : h.getActivePlayers().values()) {
                p.setActive(false);
                CampaignMain.cm.toUser("AM:" + Username + " locked the campaign. You were deactivated.", p.getName(), true);
                CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
            }
        }
        CampaignMain.cm.getConfig().setProperty("CampaignLock", "true");
        CampaignMain.cm.doSendToAllOnlinePlayers("AM:" + Username + " locked the campaign!", true);
        CampaignMain.cm.toUser("AM:You locked the campaign. Players can no longer activate, and all active players were deactivated. Use 'adminunlockcampaign' to release the activity lock.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " locked the campaign.");
    }
}

