/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class AdminLockFactoryCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet#factory#true/false";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Unknown planet!", Username, true);
                return;
            }
            SUnitFactory uf = (SUnitFactory)CampaignMain.cm.getData().getFactoryByName(p, command.nextToken());
            if (uf == null) {
                CampaignMain.cm.toUser("Unknown factory!", Username, true);
                return;
            }
            boolean lock = command.hasMoreElements() ? new Boolean(command.nextToken()) : !uf.isLocked();
            uf.setLock(lock);
            if (lock) {
                int currMiniTicks = uf.getTicksUntilRefresh();
                uf.addRefresh(9999 - currMiniTicks, true);
                CampaignMain.cm.toUser("You locked " + uf.getName() + " on planet " + p.getName(), Username, true);
                CampaignMain.cm.doSendModMail("NOTE", Username + " has locked " + uf.getName() + " on planet " + p.getName());
            } else {
                int miniTicksToRemove = uf.getTicksUntilRefresh();
                uf.addRefresh(-miniTicksToRemove, true);
                CampaignMain.cm.toUser("You unlocked " + uf.getName() + " on planet " + p.getName(), Username, true);
                CampaignMain.cm.doSendModMail("NOTE", Username + " has unlocked " + uf.getName() + " on planet " + p.getName());
            }
            if (CampaignMain.cm.isUsingMySQL()) {
                uf.toDB();
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Command failed. Make sure format was: /c adminlockfactory#planetname#factoryname", Username, true);
            CampaignData.mwlog.errLog(ex);
        }
    }
}

