/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.util.Position;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminMovePlanetCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#X Coord#Y Coord";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
        if (p == null) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        try {
            x = Double.parseDouble(command.nextToken());
            y = Double.parseDouble(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid Syntax: adminmoveplanet#name#x#y", Username);
            return;
        }
        p.setPosition(new Position(x, y));
        p.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            p.toDB();
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has moved planet " + p.getName() + " to " + x + "," + y);
        CampaignMain.cm.toUser("Planet Moved", Username);
    }
}

