/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.util.MWPasswd;

public class AdminPasswordCommand
implements Command {
    int accessLevel = 2;
    String syntax = "Admin Password Commands:<br> /c adminpassword#save - save the password file<br> /c adminpassword#remove#NAME - remove NAME's password<br> /c adminpassword#level#NAME#LEVEL - set a player's userlevel.<br> EXAMPLE: /c adminpassword#remove#urgru<br> EXAMPLE: /c adminpassword#level#urgru#200";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("Admin Password Commands:<br> /c adminpassword#save - save the password file<br> /c adminpassword#remove#NAME - remove NAME's password<br> /c adminpassword#level#NAME#LEVEL - set a player's userlevel.<br> EXAMPLE: /c adminpassword#remove#urgru<br> EXAMPLE: /c adminpassword#level#urgru#200", Username, true);
            return;
        }
        String action = command.nextToken();
        if (action.equalsIgnoreCase("save")) {
            try {
                MWPasswd.save();
                CampaignMain.cm.toUser("Password-file saved!", Username, true);
                CampaignMain.cm.doSendModMail("NOTE", Username + " has saved the password-file.");
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("Problems saving password file!", Username, true);
            }
        } else if (action.equalsIgnoreCase("remove")) {
            String target = command.nextToken();
            MWPasswd.removeRecord(target);
            try {
                MWPasswd.save();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            CampaignMain.cm.toUser("Password for " + target + " removed!", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " has removed " + target + "'s password");
        } else if (action.equalsIgnoreCase("level")) {
            String target = command.nextToken();
            int level = Integer.parseInt(command.nextToken());
            SPlayer p = CampaignMain.cm.getPlayer(target);
            try {
                MWPasswd.getRecord(target).setAccess(level);
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser(target + " is not registered. Have them register, then try again.", Username);
                return;
            }
            try {
                CampaignMain.cm.getServer().getClient(target).setAccessLevel(level);
                CampaignMain.cm.getServer().getUser(target).setLevel(level);
                CampaignMain.cm.getServer().sendRemoveUserToAll(target, false);
                CampaignMain.cm.getServer().sendNewUserToAll(target, false);
                MWPasswd.writeRecord(p.getPassword(), target);
                if (p != null) {
                    CampaignMain.cm.doSendToAllOnlinePlayers("PI|DA|" + CampaignMain.cm.getPlayerUpdateString(p), false);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            CampaignMain.cm.toUser("Level for " + target + " set to " + level + "!", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " has set " + target + "'s level to " + level);
        }
    }
}

