/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class AdminPurgeHouseBaysCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#[ALL]unittype#[ALL]unitsize";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String faction = "";
        String strType = "";
        String strClass = "";
        int unitType = 0;
        int unitClass = 0;
        try {
            faction = command.nextToken();
            strType = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: AdminPurgeHouseBays#faction#[ALL]unittype#[ALL]unitsize", Username, true);
            return;
        }
        SHouse h = CampaignMain.cm.getHouseFromPartialString(faction, Username);
        if (h == null) {
            return;
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            if (strType.equals("ALL")) {
                for (int type = 0; type < 6; ++type) {
                    for (int i = 0; i < 4; ++i) {
                        Vector<SUnit> tmpVec = h.getHangar(type).elementAt(i);
                        tmpVec.trimToSize();
                        for (SUnit currU : tmpVec) {
                            CampaignMain.cm.MySQL.deleteUnit(currU.getDBId());
                        }
                    }
                }
            } else {
                strClass = command.nextToken();
                unitType = Integer.parseInt(strType);
                if (strClass.equals("ALL")) {
                    for (int i = 0; i < 4; ++i) {
                        Vector<SUnit> tmpVec = h.getHangar(unitType).elementAt(i);
                        tmpVec.trimToSize();
                        for (SUnit currU : tmpVec) {
                            CampaignMain.cm.MySQL.deleteUnit(currU.getDBId());
                        }
                    }
                } else {
                    unitClass = Integer.parseInt(strClass);
                    Vector<SUnit> tmpVec = h.getHangar(unitType).elementAt(unitClass);
                    tmpVec.trimToSize();
                    for (SUnit currU : tmpVec) {
                        CampaignMain.cm.MySQL.deleteUnit(currU.getDBId());
                    }
                }
            }
        }
        try {
            if (strType.equals("ALL")) {
                for (Vector<Vector<SUnit>> hangers : h.getHangar().values()) {
                    for (int size = 0; size <= 3; ++size) {
                        hangers.elementAt(size).clear();
                    }
                }
            } else {
                if (!CampaignMain.cm.isUsingMySQL()) {
                    strClass = command.nextToken();
                }
                unitType = Integer.parseInt(strType);
                Vector<Vector<SUnit>> hanger = h.getHangar(unitType);
                if (strClass.equals("ALL")) {
                    for (int size = 0; size <= 3; ++size) {
                        hanger.elementAt(size).clear();
                    }
                } else {
                    if (!CampaignMain.cm.isUsingMySQL()) {
                        unitClass = Integer.parseInt(strClass);
                    }
                    hanger.elementAt(unitClass).clear();
                }
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: AdminPurgeHouseBays#faction#[ALL]unittype#[ALL]unitsize", Username, true);
            return;
        }
        h.updated();
        CampaignMain.cm.doSendModMail("NOTE", Username + " has purged bays for " + h.getName());
    }
}

