/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.House;
import common.Planet;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminRandomlySetPlanetProductionCommand
implements Command {
    int accessLevel = 200;
    String syntax = "min#max[set to 0 to reset all planets to 0]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int min = Integer.parseInt(command.nextToken());
        int max = Integer.parseInt(command.nextToken());
        if (max == 0) {
            min = 0;
        }
        if (!command.hasMoreTokens() || !command.nextToken().equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("Do you want to change all of the planets production? If so, [<a href=\"MEKWARS/c AdminRandomlySetPlanetProduction#" + min + "#" + max + "#confirm\">click to confirm.</a>", Username, true);
            return;
        }
        if (!command.hasMoreTokens() || !command.nextToken().equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("Are you *ABSOLUTELY SURE* you want to change all of the planets production? This cannot be easily reversed. If so, [<a href=\"MEKWARS/c AdminRandomlySetPlanetProduction#" + min + "#" + max + "#confirm#confirm\">click to re-confirm.</a>", Username, true);
            return;
        }
        for (Planet currP : CampaignMain.cm.getData().getAllPlanets()) {
            SPlanet p = (SPlanet)currP;
            if (p.getCompProduction() > 0 && max > 0) continue;
            int production = CampaignMain.cm.getRandomNumber(max);
            production = Math.max(production, min);
            p.setCompProduction(production);
            p.updated();
            if (!CampaignMain.cm.isUsingMySQL()) continue;
            p.toDB();
        }
        if (max == 0) {
            for (House currH : CampaignMain.cm.getData().getAllHouses()) {
                SHouse h = (SHouse)currH;
                h.setComponentProduction(0);
                int productionAmount = 0;
                for (SPlanet planet : h.getPlanets().values()) {
                    productionAmount = planet.getCompProduction();
                }
                h.setComponentProduction(productionAmount);
            }
        }
        CampaignMain.cm.toUser("You have set production for all of the planets.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set production for all of the planets.");
    }
}

