/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminRemoveAllFactoriesCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            if (p == null) {
                return;
            }
            p.getUnitFactories().clear();
            p.updated();
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.deletePlanetFactories(p.getName());
                p.toDB();
            }
            CampaignMain.cm.doSendModMail("NOTE", Username + "  removed all factories  from " + p.getName() + ".");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

