/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminRemovePlanetOwnershipCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = null;
        SHouse removingHouse = null;
        try {
            planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            removingHouse = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminremoveplanetownership#planet#faction", Username, true);
            return;
        }
        if (planet == null) {
            CampaignMain.cm.toUser("Could not find a matching planet.", Username, true);
            return;
        }
        if (removingHouse == null) {
            CampaignMain.cm.toUser("Could not find a matching faction to remove.", Username, true);
            return;
        }
        planet.getInfluence().removeHouse(removingHouse);
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " removed " + removingHouse.getName() + " as an owner of " + planet.getName() + ".");
    }
}

