/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class AdminRemoveUnitsOnMarketCommand
implements Command {
    int accessLevel = 200;
    String syntax = "[player][all][number]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String toRemove = "";
        try {
            toRemove = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminremoveunitsonmarker#[player][all][number]", Username, true);
            return;
        }
        if (toRemove.equalsIgnoreCase("all")) {
            CampaignMain.cm.getMarket().removeAllListings();
            CampaignMain.cm.toUser("You removed all units from the market.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " removed all units from the BM.");
            CampaignMain.cm.getServer().sendChat(Username + " removed all units from the BM.");
            return;
        }
        int auctionNumber = -1;
        try {
            auctionNumber = Integer.parseInt(toRemove);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (auctionNumber > -1) {
            CampaignMain.cm.getMarket().removeListing(auctionNumber);
            CampaignMain.cm.toUser("You removed auction #" + auctionNumber + " from the market.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " removed auction #" + auctionNumber + " from the market.");
        } else {
            SPlayer p = CampaignMain.cm.getPlayer(toRemove);
            if (p == null) {
                CampaignMain.cm.toUser("Couldn't find a player named " + toRemove + ".", Username, true);
                return;
            }
            if (!CampaignMain.cm.getMarket().hasActiveListings(p)) {
                CampaignMain.cm.toUser(p.getName() + " doesn't have any running auctions.", Username, true);
                return;
            }
            CampaignMain.cm.getMarket().removePlayerListings(p);
            CampaignMain.cm.toUser("You cancelled all of " + p.getName() + "'s auctions.", Username, true);
            CampaignMain.cm.toUser(Username + " cancelled all of your running auctions.", p.getName(), true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " cancelled all of " + toRemove + "'s auctions.");
        }
    }
}

