/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class AdminResetPlayerCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Player Name/Faction Name/All#CONFIRM";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String resetType = "";
        String commandConfirmed = "";
        try {
            resetType = command.nextToken();
            commandConfirmed = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminresetplayer#Player Name/Faction Name/All#CONFIRM", Username, true);
            return;
        }
        if (!commandConfirmed.equals("CONFIRM")) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminresetplayer#Player Name/Faction Name/All#CONFIRM", Username, true);
            return;
        }
        if (resetType.equalsIgnoreCase("all")) {
            File[] playerList = new File("./campaign/players").listFiles();
            for (int i = 0; i < playerList.length; ++i) {
                SPlayer player;
                File playerFile = playerList[i];
                if (playerFile.isDirectory() || (player = CampaignMain.cm.getPlayer(playerFile.getName().substring(0, playerFile.getName().indexOf(".dat")))) == null) continue;
                player.reset("CONFIRM");
                CampaignMain.cm.doLogoutPlayer(player.getName());
            }
            CampaignMain.cm.doSendModMail("NOTE", Username + " has reset all player accounts.");
        } else if (CampaignMain.cm.getHouseFromPartialString(resetType, null) != null) {
            File[] playerList = new File("./campaign/players").listFiles();
            for (int i = 0; i < playerList.length; ++i) {
                SPlayer player;
                File playerFile = playerList[i];
                if (playerFile.isDirectory() || (player = CampaignMain.cm.getPlayer(playerFile.getName().substring(0, playerFile.getName().indexOf(".dat")))) == null || !player.getMyHouse().getName().equalsIgnoreCase(resetType)) continue;
                player.reset("CONFIRM");
                CampaignMain.cm.doLogoutPlayer(player.getName());
            }
            CampaignMain.cm.doSendModMail("NOTE", Username + " has reset all player accounts for faction " + resetType);
        } else if (CampaignMain.cm.getPlayer(resetType) != null) {
            SPlayer player = CampaignMain.cm.getPlayer(resetType);
            player.reset("CONFIRM");
            CampaignMain.cm.doLogoutPlayer(player.getName());
            CampaignMain.cm.doSendModMail("NOTE", Username + " has reset " + player.getName() + "'s account.");
        }
        CampaignMain.cm.forceSavePlayers(Username);
    }
}

