/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.House;
import common.Planet;
import java.util.HashMap;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminReturnPlanetsToOriginalOwnersCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreTokens() || !command.nextToken().equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("Do you want to return all planets to their original owners? If so, [<a href=\"MEKWARS/c adminreturnplanetstooriginalowners#confirm\">click to confirm.</a>", Username, true);
            return;
        }
        if (!command.hasMoreTokens() || !command.nextToken().equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("Are you *ABSOLUTELY SURE* you want to return planets to their original owners? This cannot be easily reversed. If so, [<a href=\"MEKWARS/c adminreturnplanetstooriginalowners#confirm#confirm\">click to re-confirm.</a>", Username, true);
            return;
        }
        for (House currH : CampaignMain.cm.getData().getAllHouses()) {
            SHouse h = (SHouse)currH;
            h.getPlanets().clear();
            h.setComponentProduction(0);
        }
        for (Planet currP : CampaignMain.cm.getData().getAllPlanets()) {
            SPlanet p = (SPlanet)currP;
            SHouse origOwner = CampaignMain.cm.getHouseFromPartialString(p.getOriginalOwner(), Username);
            p.setOwner(p.getOwner(), origOwner, true);
            HashMap<Integer, Integer> flu = new HashMap<Integer, Integer>();
            flu.put(origOwner.getId(), 100);
            p.getInfluence().setInfluence(flu);
            p.updated();
            if (!CampaignMain.cm.isUsingMySQL()) continue;
            p.toDB();
        }
        CampaignMain.cm.toUser("You restored all plants to their original owners.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " restored all plants to their original owners.");
    }
}

