/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import common.Equipment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSaveBlackMarketConfigsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("./data/blackmarketsettings.dat"));
            ps.println("#Timestamp=" + System.currentTimeMillis());
            for (String key : CampaignMain.cm.getBlackMarketEquipmentTable().keySet()) {
                Equipment bme = CampaignMain.cm.getBlackMarketEquipmentTable().get(key);
                if (bme.getMaxProduction() <= 0) continue;
                ps.print(bme.getEquipmentInternalName());
                ps.print("#");
                ps.print(Math.min(bme.getMaxCost(), bme.getMinCost()));
                ps.print("#");
                ps.print(bme.getMaxCost());
                ps.print("#");
                ps.print(Math.min(bme.getMaxProduction(), bme.getMinProduction()));
                ps.print("#");
                ps.print(bme.getMaxProduction());
                ps.println("#");
            }
            ps.close();
        }
        catch (FileNotFoundException fe) {
            CampaignData.mwlog.errLog("blackmarketsettings.dat not found");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        CampaignMain.cm.toUser("AM:Black Market Settings saved!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has saved the Black Market Settings");
    }
}

