/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSaveCommandLevelsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        TreeMap<String, Command> commandTable = new TreeMap<String, Command>(CampaignMain.cm.getServerCommands());
        try {
            File fp = new File("./data/commands");
            if (!fp.exists()) {
                fp.mkdir();
            }
            FileOutputStream out = new FileOutputStream("./data/commands/commands.dat");
            PrintStream p = new PrintStream(out);
            String commandName = "";
            Iterator<String> i = commandTable.keySet().iterator();
            while (i.hasNext()) {
                Command commandMethod = CampaignMain.cm.getServerCommands().get(commandName);
                if (commandName != null && commandMethod != null) {
                    p.println(commandName.toUpperCase() + "#" + commandMethod.getExecutionLevel());
                }
                commandName = i.next();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to save command levels");
        }
        CampaignMain.cm.toUser("AM:Command levels saved!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has saved the command levels to file.");
    }
}

