/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminSaveFactionConfigsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String faction = "";
        try {
            faction = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: AdminSaveFactionConfigs#faction", Username, true);
            return;
        }
        SHouse h = CampaignMain.cm.getHouseFromPartialString(faction, Username);
        if (h == null) {
            return;
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            h.saveConfigFileToDB();
        } else {
            h.saveConfigFile();
        }
        h.setUsedMekBayMultiplier(h.getFloatConfig("UsedPurchaseCostMulti"));
        CampaignMain.cm.toUser("AM:Status saved!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has saved " + faction + "'s configs");
    }
}

