/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.campaign.pilot.Pilot;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class AdminScrapCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Target Player#Unit ID";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String targetName = (String)command.nextElement();
        SPlayer target = CampaignMain.cm.getPlayer(targetName);
        if (target == null) {
            CampaignMain.cm.toUser("Target player could not be found. Try again.", Username, true);
            return;
        }
        int unitID = Integer.parseInt((String)command.nextElement());
        SUnit m = target.getUnit(unitID);
        if (m == null) {
            CampaignMain.cm.toUser("Target player doesn't have a unit with ID# " + unitID + ".", Username, true);
            return;
        }
        Pilot currPilot = m.getPilot();
        currPilot.setGunnery(target.getMyHouse().getPilotQueues().getBaseGunnery(m.getType()));
        currPilot.setPiloting(target.getMyHouse().getPilotQueues().getBasePiloting(m.getType()));
        CampaignMain.cm.toUser("AM:" + targetName + "'s " + m.getModelName() + " was scrapped.", Username, true);
        CampaignMain.cm.toUser("AM:" + Username + " scrapped your " + m.getModelName() + " (ID#" + m.getId() + ")", targetName, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " scrapped a " + m.getModelName() + " belonging to " + targetName);
        if (CampaignMain.cm.isUsingMySQL()) {
            SPilot p = (SPilot)m.getPilot();
            CampaignMain.cm.MySQL.deletePilot(p.getPilotId());
            CampaignMain.cm.MySQL.deleteUnit(m.getDBId());
        }
        target.removeUnit(unitID, true);
    }
}

