/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import megamek.common.MiscType;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSetBanTargetingCommand
implements Command {
    int accessLevel = 200;
    String syntax = "targetingType";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int targetingType = -1;
        try {
            targetingType = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: AdminSetBanTargeting#targetingType", Username, true);
        }
        if (CampaignMain.cm.getData().getBannedTargetingSystems().get(targetingType) != null) {
            CampaignMain.cm.getData().getBannedTargetingSystems().remove(targetingType);
            CampaignMain.cm.getData().setBannedTargetingSystems(CampaignMain.cm.getData().getBannedTargetingSystems());
            CampaignMain.cm.toUser("You lifted the ban on " + MiscType.getTargetSysName(targetingType) + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " lifted the ban on " + MiscType.getTargetSysName(targetingType) + ".");
        } else {
            CampaignMain.cm.getData().getBannedTargetingSystems().put(targetingType, "banned");
            CampaignMain.cm.getData().setBannedTargetingSystems(CampaignMain.cm.getData().getBannedTargetingSystems());
            CampaignMain.cm.toUser("You banned " + MiscType.getTargetSysName(targetingType) + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " banned " + MiscType.getTargetSysName(targetingType) + ".");
        }
        CampaignMain.cm.saveBannedTargetingSystems();
    }
}

