/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import common.Equipment;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSetBlackMarketSettingCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Item Name#Min Cost#Max Cost#Min Production#Max Production";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String key = "";
        String minCost = "";
        String maxCost = "";
        String minProduction = "";
        String maxProduction = "";
        try {
            key = command.nextToken();
            minCost = command.nextToken();
            maxCost = command.nextToken();
            minProduction = command.nextToken();
            maxProduction = command.nextToken();
            Equipment bme = CampaignMain.cm.getBlackMarketEquipmentTable().get(key);
            if (bme == null) {
                bme = new Equipment();
                bme.setEquipmentInternalName(key);
            }
            bme.setMinCost(Double.parseDouble(minCost));
            bme.setMaxCost(Double.parseDouble(maxCost));
            bme.setMinProduction(Integer.parseInt(minProduction));
            bme.setMaxProduction(Integer.parseInt(maxProduction));
            CampaignMain.cm.getBlackMarketEquipmentTable().put(key, bme);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

