/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetHomeWorldCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#[true/false]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean homeworld = false;
        SPlanet planet = null;
        try {
            planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            homeworld = command.hasMoreTokens() ? Boolean.parseBoolean(command.nextToken()) : !planet.isHomeWorld();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: adminsethomeworld#Planet#[true/false]", Username);
        }
        if (planet == null) {
            return;
        }
        planet.setHomeWorld(homeworld);
        CampaignMain.cm.toUser(planet.getName() + "'s homeworld status set to: " + homeworld + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set " + planet.getName() + "'s homeworld status to: " + homeworld + ".");
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
    }
}

