/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminSetHouseAbbreviationCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#Shortname";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String houseAbbreviation;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String HouseName = "";
        SHouse faction = null;
        try {
            HouseName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsethouseabbreviation#faction#shortname", Username, true);
            return;
        }
        faction = CampaignMain.cm.getHouseFromPartialString(HouseName, Username);
        if (faction == null) {
            CampaignMain.cm.toUser("Couldn't find a faction with that name.", Username, true);
            return;
        }
        try {
            houseAbbreviation = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsethouseabbreviation#faction#shortname", Username, true);
            return;
        }
        faction.setAbbreviation(houseAbbreviation);
        faction.updated();
        CampaignMain.cm.doSendModMail("NOTE", Username + " changed the faction abbreviation for " + HouseName);
        CampaignMain.cm.toUser(HouseName + " abbreviation changed.", Username, true);
    }
}

