/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminSetHouseAmmoBanCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#Munition Number";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String faction = "";
        String ammoName = "";
        try {
            faction = command.nextToken();
            ammoName = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax. Try: adminsethouseammoban#faction#munitionnumber", Username, true);
        }
        SHouse h = CampaignMain.cm.getHouseFromPartialString(faction, Username);
        if (h == null) {
            return;
        }
        if (h.getBannedAmmo().get(ammoName) != null) {
            h.getBannedAmmo().remove(ammoName);
            ammoName = CampaignMain.cm.getData().getMunitionsByNumber().get(new Long(ammoName));
            CampaignMain.cm.toUser("Ban on " + ammoName + " lifted for " + h.getName() + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " lifted the ban on " + ammoName + " for " + h.getName() + ".");
        } else {
            h.getBannedAmmo().put(ammoName, "banned");
            ammoName = CampaignMain.cm.getData().getMunitionsByNumber().get(new Long(ammoName));
            CampaignMain.cm.toUser("Banned " + ammoName + " for " + h.getName() + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " banned " + ammoName + " for " + h.getName() + ".");
        }
        h.updated();
        CampaignMain.cm.saveBannedAmmo();
    }
}

