/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class AdminSetHousePlayerColorCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#htmlhexcolor";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String houseColor;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String HouseName = "";
        SHouse faction = null;
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            HouseName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsethouseplayercolormod#faction#htmlhexcolor", Username, true);
            return;
        }
        faction = CampaignMain.cm.getHouseFromPartialString(HouseName);
        if (faction == null) {
            CampaignMain.cm.toUser("Couldn't find a faction with that name.", Username, true);
            return;
        }
        if (userLevel < 100) {
            faction = player.getMyHouse();
        }
        try {
            houseColor = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsethouseplayercolormod#faction#htmlhexcolor", Username, true);
            return;
        }
        faction.setHousePlayerColors(houseColor);
        faction.updated();
        CampaignMain.cm.doSendModMail("NOTE", Username + " changed the faction playerlist color for " + HouseName);
        CampaignMain.cm.toUser(HouseName + " color changed.", Username, true);
    }
}

