/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import megamek.common.TechConstants;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminSetHouseTechLevelCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#TechLevel";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int techLevel;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse house = null;
        try {
            house = CampaignMain.cm.getHouseFromPartialString(command.nextToken());
            techLevel = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsethousetechlevel#faction#techlevel", Username, true);
            return;
        }
        house.setTechLevel(techLevel);
        house.updated();
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set " + house.getName() + "'s tech level to " + TechConstants.getLevelDisplayableName(techLevel) + ".");
    }
}

