/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetPlanetGravityCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Gravity(Double)";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
        if (planet == null) {
            CampaignMain.cm.toUser("Unknown Planet", Username, true);
            return;
        }
        double grav = Double.parseDouble(command.nextToken());
        planet.setGravity(grav);
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
        CampaignMain.cm.toUser("Gravity set for " + planet.getName(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set the gravity for " + planet.getName());
    }
}

