/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetPlanetOpFlagsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#FlagCode#FlagCode#...<br>NOTE: you can repeat FlagCode multiple times.<br>NOTE:This will reset all the flags for the planet to these flags!";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("Syntax AdminSetPlanetOpFlags#Planet#FlagCode#FlagCode#...<br>NOTE: you can repeat FlagCode multiple times.<br>NOTE:This will reset all the flags for the planet to these flags!", Username);
            return;
        }
        SPlanet planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
        if (planet == null) {
            CampaignMain.cm.toUser("Unknown Planet", Username, true);
            return;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            while (command.hasMoreTokens()) {
                String key = command.nextToken();
                if (CampaignMain.cm.getData().getPlanetOpFlags().containsKey(key)) {
                    map.put(key, CampaignMain.cm.getData().getPlanetOpFlags().get(key));
                    continue;
                }
                CampaignMain.cm.toUser(key + " is not a valid plant ops flag!", Username);
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Syntax AdminSetPlanetOpFlags#Planet#FlagCode#FlagCode#...<br>NOTE: you can repeat FlagCode multiple times.<br>NOTE:This will reset all the flags for the planet to these flags!", Username);
            return;
        }
        planet.setPlanetFlags(map);
        CampaignMain.cm.toUser("Op flags set for " + planet.getName(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set the op flags for " + planet.getName());
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
    }
}

