/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetPlanetOriginalOwnerCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String PlanetName = command.nextToken();
        String originalOwner = CampaignMain.cm.getConfig("NewbieHouseName");
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(PlanetName, Username);
        if (planet == null) {
            return;
        }
        try {
            if (command.hasMoreTokens()) {
                originalOwner = command.nextToken();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        planet.setOriginalOwner(originalOwner);
        CampaignMain.cm.toUser(planet.getName() + "'s original owner set to: " + originalOwner + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " changed " + PlanetName + " 's original owner to: " + originalOwner + ".");
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
    }
}

