/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class AdminTransferCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Sending Player#Receiving Player#Unit ID";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String sendingPlayer = null;
        String receivingPlayer = null;
        int mechid = -1;
        try {
            sendingPlayer = (String)command.nextElement();
            receivingPlayer = (String)command.nextElement();
            mechid = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c admintransfer#from#to#id", Username, true);
            return;
        }
        SPlayer sender = CampaignMain.cm.getPlayer(sendingPlayer);
        SPlayer receiver = CampaignMain.cm.getPlayer(receivingPlayer);
        if (sender == null) {
            CampaignMain.cm.toUser("AM:Sending player could not be found. Try again.", Username, true);
            return;
        }
        if (receiver == null) {
            CampaignMain.cm.toUser("AM:Receiving player could not be found. Try again.", Username, true);
            return;
        }
        SUnit m = sender.getUnit(mechid);
        if (m == null) {
            CampaignMain.cm.toUser("AM:Sender doesn't have a unit with ID# " + mechid + ".", Username, true);
            return;
        }
        CampaignMain.cm.toUser("AM:You transfered " + sendingPlayer + "'s " + m.getModelName() + " to " + receiver.getName(), Username, true);
        CampaignMain.cm.toUser("AM:" + Username + " forced " + sendingPlayer + " to send you a " + m.getModelName() + ".", receivingPlayer, true);
        CampaignMain.cm.toUser("AM:" + Username + " forced you to send your " + m.getModelName() + " to " + receivingPlayer + ".", sendingPlayer, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " transfers a " + m.getModelName() + " from " + sendingPlayer + " to " + receivingPlayer);
        sender.removeUnit(m.getId(), true);
        receiver.addUnit(m, true);
    }
}

