/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminUpdatePlanetOwnershipCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Faction Name#amount";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String houseName;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = null;
        SHouse house = null;
        int ownerShip = 0;
        int id = -1;
        try {
            planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            houseName = command.nextToken();
            house = CampaignMain.cm.getHouseFromPartialString(houseName, null);
            ownerShip = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminupdateplanetownership#planet#faction#amount", Username, true);
            return;
        }
        if (planet == null) {
            CampaignMain.cm.toUser("Could not find a matching planet.", Username, true);
            return;
        }
        if (house == null && !houseName.equalsIgnoreCase("none")) {
            CampaignMain.cm.toUser("Could not find a matching faction to remove.", Username, true);
            return;
        }
        if (ownerShip <= 0) {
            CampaignMain.cm.toUser("Ownership cannot be less then or equal to 0", Username, true);
            return;
        }
        if (house != null) {
            id = house.getId();
        }
        if (ownerShip == planet.getInfluence().getInfluence(id)) {
            return;
        }
        planet.getInfluence().updateHouse(id, ownerShip);
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " updated " + houseName + " ownership of " + planet.getName() + " to " + ownerShip + ".");
    }
}

