/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminUploadBuildTableCommand
implements Command {
    int accessLevel = 200;
    String syntax = "[rare/reward/standard]/Build Table File Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String fileName = "./data/buildtables/" + command.nextToken();
        try {
            File newTable = new File(fileName);
            if (newTable.exists()) {
                String newFileName = fileName + ".bak";
                File backupFile = new File(newFileName);
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                newTable.renameTo(backupFile);
                newTable.delete();
            }
            FileOutputStream out = new FileOutputStream(fileName);
            PrintStream p = new PrintStream(out);
            while (command.hasMoreTokens()) {
                p.println(command.nextToken());
            }
            p.close();
            out.close();
            CampaignMain.cm.toUser(fileName + " Saved", Username, true);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("File Not found", Username, true);
            return;
        }
    }
}

