/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminViewLogCommand
implements Command {
    int accessLevel = 200;
    String syntax = "/path/file";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String fileName = command.nextToken();
        if (fileName.startsWith("../")) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " tried to viewed file " + fileName + " but was denied!");
            CampaignMain.cm.toUser("Sorry but you are not allowed to backout of the root directory!", Username, true);
            return;
        }
        try {
            File logFile = new File("./" + fileName);
            if (logFile.length() > 0x2EE000L) {
                CampaignMain.cm.toUser("The file you are trying to open is over 3 megs that is not allowed!", Username, true);
                return;
            }
            FileInputStream fis = new FileInputStream(logFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                CampaignMain.cm.toUser("SM|" + dis.readLine(), Username, false);
            }
            fis.close();
            dis.close();
            CampaignMain.cm.doSendModMail("NOTE", Username + " has viewed file" + logFile);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("File Not found", Username, true);
            return;
        }
    }
}

