/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Equipment;
import common.util.UnitUtils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AutoFillBlackMarketSettingCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Min Cost Modifer#Max Cost Modifer#Min Production#Max Production#Unit Weight(optional)";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        double minCost = 1.0;
        double maxCost = 1.0;
        double maxCostMod = 1.0;
        double minCostMod = 1.0;
        double baseCost = 1.0;
        Entity ent = UnitUtils.createOMG();
        int minProduction = 0;
        int maxProduction = 0;
        minCostMod = Double.parseDouble(command.nextToken());
        maxCostMod = Double.parseDouble(command.nextToken());
        minProduction = Integer.parseInt(command.nextToken());
        maxProduction = Integer.parseInt(command.nextToken());
        if (command.hasMoreElements()) {
            ent.setWeight(Float.parseFloat(command.nextToken()));
        }
        Enumeration<EquipmentType> list = EquipmentType.getAllTypes();
        double crits = 1.0;
        while (list.hasMoreElements()) {
            EquipmentType eq = list.nextElement();
            String key = eq.getInternalName();
            if (eq instanceof AmmoType) {
                crits = ((AmmoType)eq).getRackSize();
            } else if (this.isArmor(eq)) {
                crits = 16.0 * EquipmentType.getArmorPointMultiplier(EquipmentType.getArmorType(eq.getName()));
            } else if (this.isStructure(eq)) {
                crits = 8.0;
            } else {
                try {
                    crits = eq.getCriticals(ent);
                }
                catch (Exception ex) {
                    crits = 1.0;
                }
            }
            crits = Math.max(crits, 1.0);
            baseCost = eq.getCost();
            if (baseCost == -2.147483648E9) {
                baseCost = eq.resolveVariableCost(ent);
            } else if (this.isArmor(eq)) {
                baseCost = EquipmentType.getArmorCost(EquipmentType.getArmorType(eq.getName()));
            } else if (this.isStructure(eq)) {
                baseCost = EquipmentType.getStructureCost(EquipmentType.getStructureType(eq.getName()));
            } else if (eq instanceof MiscType) {
                if (eq.hasFlag(1L) || eq.hasFlag(2L)) {
                    baseCost = eq.getName().equals("1 Compact Heat Sink") ? 3000.0 : (eq.getName().equals("Heat Sink") ? 2000.0 : 6000.0);
                } else if (eq.hasFlag(0x10000000L)) {
                    baseCost = 6.0 * (double)ent.getWeight() * 150.0;
                } else if (eq.hasFlag(4L)) {
                    baseCost = eq.getTechLevel() > 3 ? 6.0 * (double)ent.getWeight() * 500.0 : 6.0 * (double)ent.getWeight() * 200.0;
                } else if (eq.hasFlag(0x40000000L)) {
                    baseCost = 6.0 * (double)ent.getWeight() * 200.0;
                }
            }
            baseCost /= crits;
            baseCost = Math.max(0.0, baseCost);
            minCost = baseCost * minCostMod;
            maxCost = baseCost * maxCostMod;
            Equipment bme = CampaignMain.cm.getBlackMarketEquipmentTable().get(key);
            if (bme == null) {
                bme = new Equipment();
                bme.setEquipmentInternalName(eq.getInternalName());
            }
            bme.setMinCost(minCost);
            bme.setMaxCost(maxCost);
            if (maxCost <= 0.0) {
                bme.setMinProduction(0);
                bme.setMaxProduction(0);
            } else {
                bme.setMinProduction(minProduction);
                bme.setMaxProduction(maxProduction);
            }
            CampaignMain.cm.getBlackMarketEquipmentTable().put(key, bme);
        }
        Equipment bme = new Equipment();
        bme.setEquipmentInternalName("Armor (STD)");
        baseCost = EquipmentType.getStructureCost(0);
        minCost = (baseCost /= 16.0) * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName("IS (STD)");
        baseCost = EquipmentType.getStructureCost(0) * (double)ent.getWeight();
        minCost = (baseCost /= 8.0) * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.systemNames[0]);
        baseCost = 25000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.systemNames[1]);
        baseCost = 1000.0f * ent.getWeight();
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(1));
        baseCost = 750000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(3));
        baseCost = 700000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(4));
        baseCost = 700000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(0));
        baseCost = 200000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(2));
        baseCost = 175000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getCockpitTypeString(2));
        baseCost = 175000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName("Actuator");
        baseCost = 100.0f * ent.getWeight();
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getGyroTypeString(0));
        baseCost = 300000 * (int)Math.ceil((float)ent.getOriginalWalkMP() * ent.getWeight() / 100.0f);
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getGyroTypeString(3));
        baseCost = 500000 * (int)Math.ceil((float)ent.getOriginalWalkMP() * ent.getWeight() / 100.0f) * 2;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getGyroTypeString(1));
        baseCost = (double)(750000 * (int)Math.ceil((float)ent.getOriginalWalkMP() * ent.getWeight() / 100.0f)) * 0.5;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(Mech.getGyroTypeString(2));
        baseCost = (double)(400000 * (int)Math.ceil((float)ent.getOriginalWalkMP() * ent.getWeight() / 100.0f)) * 1.5;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[0]);
        baseCost = (double)((float)(5000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[1]);
        baseCost = (double)((float)(15000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[2]);
        baseCost = (double)((float)(20000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[3]);
        baseCost = (double)((float)(100000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[4]);
        baseCost = (double)((float)(20000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName(UnitUtils.ENGINE_TECH_STRING[5]);
        baseCost = (double)((float)(100000 * ent.getEngine().getRating()) * ent.getWeight()) / 75.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName("ISTargeting Computer");
        baseCost = 10000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        bme = new Equipment();
        bme.setEquipmentInternalName("CLTargeting Computer");
        baseCost = 10000.0;
        minCost = baseCost * minCostMod;
        maxCost = baseCost * maxCostMod;
        bme.setMinCost(minCost);
        bme.setMaxCost(maxCost);
        bme.setMinProduction(minProduction);
        bme.setMaxProduction(maxProduction);
        CampaignMain.cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
        CampaignMain.cm.toUser("AM:Done setting equipment costs for the black market.", Username);
    }

    private boolean isArmor(EquipmentType eq) {
        for (String armor : EquipmentType.armorNames) {
            if (!eq.getName().equalsIgnoreCase(armor)) continue;
            return true;
        }
        return false;
    }

    private boolean isStructure(EquipmentType eq) {
        for (String IS : EquipmentType.structureNames) {
            if (!eq.getName().equalsIgnoreCase(IS)) continue;
            return true;
        }
        return false;
    }
}

