/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ChangeNameCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Old Name#New Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String oldName = "";
        String newName = "";
        try {
            oldName = command.nextToken();
            newName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c changename#oldname#newname", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(oldName);
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find player with name " + oldName, Username, true);
            return;
        }
        if (p.getDutyStatus() != 2) {
            CampaignMain.cm.toUser("You may only rename players who are in reserve.", Username, true);
            return;
        }
        CampaignMain.cm.doLogoutPlayer(oldName);
        p.getMyHouse().removePlayer(p, false);
        File fp = new File("./campaign/players/" + p.getName().toLowerCase() + ".dat");
        if (fp.exists()) {
            fp.delete();
        }
        p.setName(newName);
        if (CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.MySQL.changeForumName(oldName, newName);
        }
        CampaignMain.cm.forceSavePlayer(p);
        CampaignMain.cm.toUser("You changed " + oldName + "'s name to '" + newName + "'.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " changed " + oldName + "'s name to '" + newName + "'.");
        CampaignMain.cm.toUser(Username + " changed your name from '" + oldName + "' name to '" + newName + "'. Quit and re-join " + "for the change to take full effect.", oldName, true);
    }
}

