/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;

public class CreateUnitCommand
implements Command {
    int accessLevel = 200;
    String syntax = "filename#flavortext#gunnery#pilot#weightclass#skill1,skill2,skill3[Random]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String piloting;
        String gunnery;
        String FlavorText;
        String filename;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        try {
            filename = command.nextToken();
            FlavorText = command.nextToken();
            gunnery = command.nextToken();
            piloting = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser(this.syntax, Username);
            return;
        }
        int weight = 0;
        if (command.hasMoreElements()) {
            weight = Integer.parseInt(command.nextToken());
        }
        SUnit cm = new SUnit(FlavorText, filename, weight);
        SPilot pilot = null;
        pilot = gunnery.equals("99") || piloting.equals("99") ? new SPilot("Vacant", 99, 99) : new SPilot(SPilot.getRandomPilotName(CampaignMain.cm.getR()), Integer.parseInt(gunnery), Integer.parseInt(piloting));
        pilot.setCurrentFaction("Common");
        if (command.hasMoreTokens()) {
            String skillTokens = command.nextToken();
            StringTokenizer skillList = new StringTokenizer(skillTokens, ",");
            while (skillList.hasMoreTokens()) {
                String skill = skillList.nextToken();
                SPilotSkill pSkill = null;
                pSkill = skill.equalsIgnoreCase("random") ? CampaignMain.cm.getRandomSkill(pilot, cm.getType()) : CampaignMain.cm.getPilotSkill(skill);
                if (pSkill == null) continue;
                if (pSkill instanceof TraitSkill) {
                    ((TraitSkill)pSkill).assignTrait(pilot);
                }
                pSkill.addToPilot(pilot);
                pSkill.modifyPilot(pilot);
            }
        }
        cm.setPilot(pilot);
        p.addUnit(cm, true);
        CampaignMain.cm.toUser("Unit created: " + filename + " " + FlavorText + " " + gunnery + " " + piloting + " " + pilot.getSkillString(true) + ". ID #" + cm.getId(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " created a unit: " + filename + " " + FlavorText + " " + gunnery + " " + piloting + " " + pilot.getSkillString(true));
        if (CampaignMain.cm.isKeepingUnitHistory()) {
            CampaignMain.cm.MySQL.addHistoryEntry(1, cm.getDBId(), 0, cm.getProducer());
            CampaignMain.cm.MySQL.addHistoryEntry(2, pilot.getDBId(), 18, "Assigned to " + cm.getModelName());
            CampaignMain.cm.MySQL.addHistoryEntry(1, cm.getDBId(), 18, pilot.getName() + " assigned to unit");
        }
    }
}

