/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class CyclopsTemplateLoaderCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        SUnit unit;
        ZipEntry entry;
        ZipInputStream zipFile;
        FileInputStream in;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isUsingCyclops()) {
            return;
        }
        Vector<SUnit> units = new Vector<SUnit>(1, 1);
        String entityName = "";
        try {
            in = new FileInputStream("./data/unitfiles/Meks.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                try {
                    entry = zipFile.getNextEntry();
                    entityName = entry.getName();
                    if (entityName.startsWith("Error") || (unit = new SUnit("null", entityName, 0)) == null) continue;
                    units.add(unit);
                }
                catch (Exception ex) {}
            }
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Meks.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Meks.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Vehicles.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                try {
                    entry = zipFile.getNextEntry();
                    entityName = entry.getName();
                    unit = new SUnit("null", entityName, 0);
                    if (unit == null) continue;
                    units.add(unit);
                }
                catch (Exception ex) {}
            }
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Vehicles.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Vehicles.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Infantry.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                try {
                    entry = zipFile.getNextEntry();
                    entityName = entry.getName();
                    unit = new SUnit("null", entityName, 0);
                    if (unit == null) continue;
                    units.add(unit);
                }
                catch (Exception ex) {}
            }
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Infantry.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Infantry.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
        if (!units.isEmpty()) {
            CampaignMain.cm.toUser("Sending Template Packet", Username, true);
            CampaignMain.cm.getMWCC().unitTemplateWriteFromList(units);
            CampaignMain.cm.toUser("Finished Sending Packet", Username, true);
        }
        CampaignMain.cm.toUser("Template Loading Done.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Cyclops Template loader Command!");
    }
}

