/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.util.StringTokenizer;
import server.MWChatServer.MWChatServer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class DeleteAccountCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Name#ScrapUnits[true/false]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        File fp;
        boolean scrapUnits;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
            scrapUnits = Boolean.parseBoolean(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c deleteaccount#Name#ScrapUnits", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find a player with that name.", Username, true);
            return;
        }
        if (p.getDutyStatus() > 2) {
            CampaignMain.cm.toUser("Fighting and active players may not be deleted.", Username, true);
            return;
        }
        p.getMyHouse().removePlayer(p, !scrapUnits);
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deletePlayer(p);
        }
        if ((fp = new File("./campaign/players/" + p.getName().toLowerCase() + ".dat")).exists()) {
            fp.delete();
        }
        CampaignMain.cm.toUser("You deleted " + p.getName() + "'s account.", Username, true);
        CampaignMain.cm.toUser(Username + " deleted your account.", p.getName(), true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " deleted " + p.getName() + "'s account.");
        CampaignMain.cm.doLogoutPlayer(p.getName());
        if (CampaignMain.cm.getServer().getClient(MWChatServer.clientKey(p.getName())) != null) {
            CampaignMain.cm.getServer().killClient(p.getName(), Username);
        }
    }
}

