/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class FluffCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Player Name#[fluff text][blank to clear]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        String fluff = "";
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper command. Try: /c fluff#PlayerName#text to set text or /c fluff#PlayerName to clear", Username, true);
            return;
        }
        try {
            fluff = command.nextToken();
        }
        catch (Exception e) {
            fluff = null;
        }
        if (p == null) {
            CampaignMain.cm.toUser("AM:Couldn't find a player with that name.", Username, true);
            return;
        }
        if (fluff != null) {
            if (fluff.indexOf("~") > 0 || fluff.indexOf("$") > 0 || fluff.indexOf("#") > 0 || fluff.indexOf("|") > 0) {
                CampaignMain.cm.toUser("AM:Illegal characters in the fluff text try again without '|','$','#', or '~' characters", Username, true);
                return;
            }
            p.setFluffText(fluff);
            CampaignMain.cm.toUser("AM:New fluff text for " + p.getName() + ": " + fluff, Username, true);
            CampaignMain.cm.toUser("AM:" + Username + " set your fluff to: " + fluff, p.getName(), true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " set " + p.getName() + "'s fluff to '" + fluff + "'.");
        } else {
            p.setFluffText("");
            CampaignMain.cm.toUser("AM:Removed fluff from " + p.getName() + ".", Username, true);
            CampaignMain.cm.toUser("AM:" + Username + " removed your fluff text.", p.getName(), true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " removed " + p.getName() + "'s fluff.");
        }
        CampaignMain.cm.doSendToAllOnlinePlayers("PI|FT|" + p.getName() + "|" + p.getFluffText(), false);
    }
}

