/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ForcedDefectCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Player Name#Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        SHouse h = null;
        boolean playerOnline = false;
        try {
            String name = command.nextToken();
            playerOnline = CampaignMain.cm.isLoggedIn(name);
            p = CampaignMain.cm.getPlayer(name);
            h = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), null);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper command. Try: /c forceddefect#player#faction", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("AM:Couldn't find a player with that name.", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("AM:Couldn't find a faction with that name.", Username, true);
            return;
        }
        if (CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.MySQL.removeUserFromHouseForum(p.getForumID(), p.getMyHouse().getForumID());
        }
        String clientVersion = p.getPlayerClientVersion();
        p.getMyHouse().removeLeader(p.getName());
        p.getMyHouse().removePlayer(p, false);
        p.setMyHouse(h);
        p.setSubFaction(h.getZeroLevelSubFaction());
        if (playerOnline) {
            CampaignMain.cm.getPlayer(p.getName());
            CampaignMain.cm.doLoginPlayer(p.getName());
        }
        if (CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.MySQL.addUserToHouseForum(p.getForumID(), p.getMyHouse().getForumID());
        }
        CampaignMain.cm.toUser("AM:" + Username + " forced you to defect to " + h.getName(), p.getName(), true);
        CampaignMain.cm.toUser("AM:You forced " + p.getName() + " to defect to " + h.getName(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " forced " + p.getName() + " to defect to " + h.getName());
        p.setPlayerClientVersion(clientVersion);
    }
}

